<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "classi/Slider.php";
    
    if(isset($_GET["id"])) {
        $elemento       = $geecomDb->leggiSingolaRiga("geec_slide",filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
        $datiOccorrenza = $geecomDb->leggiSingolaRiga("geec_slider",$elemento["idSlider"]);
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione slide</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>
	
        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">

                <?php 
                    if(isset($_GET["status"])) {
                        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
                    }
                    else {
                        $status = 0;
                    }

                ?>
                    <div class="row py-4">
                        <?php 
                            if($status==200) {
                                echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Slide modificata
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==210) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Slide duplicata, modificalo per non avere due slide uguali
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                        ?>
                        
                        <div class="col-lg-8">
                            <div class="form-row justify-content-between mb-3">
                                <div class="col-auto d-flex">
                                    <nav aria-label="breadcrumb" class="align-self-center">
                                        <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                            <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                            <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                            <li class="breadcrumb-item"><a href="index.php">Slider</a></li>
                                            <li class="breadcrumb-item"><a href="creaSlider.php?id=<?php echo $datiOccorrenza["id"] ?>"><?php echo $datiOccorrenza["nome"] ?></a></li>
                                            <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($elemento)? $elemento["nome"] : "Nuovo elemento"))?></li>
                                        </ol>
                                    </nav>
                                </div>
                                <div class="col-auto text-right">
                                    <a class="btn btn-outline-primary" href="creaSlider.php?id=<?php echo $elemento["idSlider"] ?>"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                </div>
                            </div>
                            
                            <div class="card mb-4 box-shadow-lite">
                                <form name="formComponente" action="controller/controllerComponente.php" method="post">
                                    
                                    <input type="text" class="d-none" name="operazione" value="modificaElemento">
                                    <input type="text" class="d-none" name="id" value="<?php echo((isset($elemento) ? $elemento["idSlider"] : "0")); ?>">
                                    <input type="text" class="d-none" name="idElemento" value="<?php echo((isset($elemento) ? $elemento["id"] : "0")); ?>">
                                    
                                    <div class="card-header">
                                        <div class="row">
                                            <div class="form-group col-12 flex-lg-shrink-1 d-md-flex align-items-center">
                                                <label class="mr-3 mb-md-0">Nome</label>
                                                <input type="text" class="form-control form-control-lg" id="nomeSlider" name="nome" aria-describedby="nome elemento" value="<?php echo((isset($elemento) ? $elemento["nome"] : "")) ?>" placeholder="Nome occorrenza">
                                            </div>
                                            
                                            <div class="form-group col-12 col-md-5">
                                                <label>Link</label>
                                                <input  type="text" class="form-control" name="link" value="<?php echo((isset($elemento)? $elemento["link"] : ""))?>" placeholder="Link">
                                            </div>
                                            <?php
                                                $tipi = Array("sfondo"=>"Immagine o video di sfondo","soloImmagine"=>"Immagine in tag img","videoInTag"=>"Video avviabile","html"=>"Html");
                                            ?>
                                            <div class="form-group col-6 col-md-3">
                                                <label for="sottotitolo-articolo">Contenuto</label>
                                                <select class="form-control" name="tipo" id="tipo" onchange="aggiornaCampiVisibili()">
                                                    <?php
                                                        foreach($tipi as $tipo=>$nomeTipo) {
                                                            if($tipo==$elemento["tipo"]) {
                                                                echo"<option value=\"$tipo\" selected > {$nomeTipo} </option>";
                                                            }
                                                            else {
                                                                echo"<option value=\"$tipo\"> {$nomeTipo} </option>";
                                                            }
                                                        }
                                                    ?>
                                                </select>
                                            </div>

                                            <div class="form-group col-6 col-md-2">
                                                <label class="d-block" for="sottotitolo-articolo">Overlay</label>
                                                <input type="checkbox" name="overlay" class="js-switch" <?php echo((isset($elemento) && $elemento["overlay"]=="si") ? "checked" : "1") ?> value="si">
                                            </div>
                                            
                                            <div class="form-group col-6 col-md-2">
                                                <label class="d-block" for="sottotitolo-articolo">Gradiente</label>
                                                <input type="checkbox" name="gradiente" class="js-switch" <?php echo((isset($elemento) && $elemento["gradiente"]=="si") ? "checked" : "1") ?> value="si">
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="card-body">
                                        <div class="form-row">
                                            <div id="divTextarea" class="<?= ($elemento["tipo"]=="soloImmagine" || $elemento["tipo"]=="videoInTag") ? "d-none" : "form-group col-12" ?>">
                                                 <textarea class="tiny" name="testo"><?php echo(isset($elemento) ? $elemento["testo"] : "") ?></textarea>
                                            </div>

                                            <div id="divLinkPulsante" class="<?= ($elemento["tipo"]=="soloImmagine" || $elemento["tipo"]=="videoInTag" || $elemento["tipo"]=="html") ? "d-none" : "form-group col-md-6" ?>">
                                                 <label for="titolo-articolo">Link pulsante</label>
                                                 <input  type="text" class="form-control" name="linkPulsante" value="<?php echo((isset($elemento)? $elemento["linkPulsante"] : ""))?>" placeholder="Link pulsante">
                                            </div>

                                            <div id="divEtichettaPulsante" class="<?= ($elemento["tipo"]=="soloImmagine" || $elemento["tipo"]=="videoInTag" || $elemento["tipo"]=="html") ? "d-none" : "form-group col-md-3" ?>">
                                                 <label for="titolo-articolo">Etichetta pulsante</label>
                                                 <input  type="text" class="form-control" name="titoloPulsante" value="<?php echo((isset($elemento)? $elemento["titoloPulsante"] : ""))?>" placeholder="Link">
                                            </div>

                                            <div id="divStilePulsante" class="<?= ($elemento["tipo"]=="soloImmagine" || $elemento["tipo"]=="videoInTag" || $elemento["tipo"]=="html") ? "d-none" : "form-group col-md-3" ?>">
                                                 <label for="titolo-articolo">Stile pulsante</label>
                                                 <input  type="text" class="form-control" name="stilePulsante" value="<?php echo((isset($elemento)? $elemento["stilePulsante"] : ""))?>" placeholder="Link">
                                            </div>
                                        </div>                             
                                    </div>
                                </form>
                            </div>
                        </div>
                        
                        <div class="col-lg-4 align-self-start sticky-top">
                            <div class="btn-group d-flex mb-3" role="group" aria-label="Basic example">
                                <button class="btn btn-primary mt-2 mt-lg-0" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                                <button type="button" class="btn btn-warning mt-2 mt-lg-0" onclick="location.href='controller/controllerComponente.php?id=<?php echo $elemento["idSlider"] ?>&operazione=duplicaElemento&idElemento=<?php echo $elemento["id"] ?>';"><i class="far fa-clone mr-2"></i>Duplica</button>
                            </div>
                            
                            <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                                <div class="card-header collapsed" data-toggle="collapse" href="#FileMultimedialeInEvidenza">
                                    <a class="card-title">
                                        File Multimediale
                                    </a>
                                </div>
                                <div id="FileMultimedialeInEvidenza" class="collapse show">
                                    <div class="card-body">
                                        <div class="img-container">
                                            <div class="azioni">
                                                <div class="btn-group" role="group" aria-label="">
                                                    <button onclick="eliminaFileMultimedialeElemento()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                                </div>
                                            </div>
                                            <div id="contenutoFileMultimedialeInEvidenza">
                                                <?php 
                                                    if(strpos($elemento["percorsoFileMultimediale"],".mp4")>0) {
                                                        ?>
                                                        <video width="100%" height="auto" controls>
                                                            <source src="../../../<?= $elemento["percorsoFileMultimediale"] ?>">
                                                        </video>
                                                        <?php
                                                    }
                                                    else {
                                                        ?>
                                                        <img id="immagineElemento" class="img-fluid w-100 mb-3" src="../../../<?php echo((isset($elemento) && $elemento["percorsoFileMultimediale"]!="") ? $elemento["percorsoFileMultimediale"] : "immagini/altro/segnaposto.png") ?>" alt="immagine attuale">
                                                        <?php
                                                    }
                                                ?>
                                            </div>
                                        </div>

                                        <button type="button" class="btn btn-outline-primary btn-block mb-3" onclick="apriPopupSelezioneImmagini()"><i class="far fa-image"></i> Scegli da immagini caricate</button>

                                        <form action="controller/controllerComponente.php" id="frmFileUpload-00" class="dropzone singolo-file" method="post" enctype="multipart/form-data">
                                            <div class="dz-message">
                                                <i class="fas fa-file-upload fa-2x mb-2"></i>
                                                <h5>Trascina o carica in quest'area</h5>
                                            </div>
                                            <div class="fallback">
                                                <input name="file" type="file" />
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                </div>
            </div>
        </main>

        <?php 
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../../include/modal/modalSelezionaFoto.php";
            
            include "../include/jsBaseComponenti.php";
        ?>
        
        <!-- Dropzone -->
        <script type="text/javascript" src="../../../plugins/dropzone/dropzone.js"></script>
        <script>
            $("#frmFileUpload-00").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.webp,.gif,.svg,.mp4",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    var divImmagine = document.getElementById("immagineElemento");

                    if(response.indexOf(".mp4")>0) { // se l'utente ha caricato un video bisogna ricaricare
                        location.reload();
                    }
                    else if(divImmagine!=null) {
                        divImmagine.src=response;
                        this.removeAllFiles();
                    }
                    else {
                        location.reload();
                    }
                },
                params:{
                    operazione:"modificaFileMultimedialeElemento",
                    idElemento:<?php echo $elemento["id"] ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
            
            function eliminaFileMultimedialeElemento() {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"eliminaFileMultimedialeElemento",
                        id:<?php echo $elemento["idSlider"] ?>,
                        idElemento:<?php echo $elemento["id"] ?>
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            var divImmagine = document.getElementById("immagineElemento");
                            
                            if(divImmagine!=null) {
                                document.getElementById("immagineElemento").src="../../../immagini/altro/segnaposto.png";
                            }
                            else {
                                location.reload();
                            }
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
                     
            function apriPopupSelezioneImmagini() {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerRisorse.php",
                    data:{
                        operazione:"stampaImmaginiCartellaSlider",
                        id:<?php echo $elemento["id"] ?>,
                        immaginePartenza:0,
                        numeroImmagini:18
                    },
                    success:function(codice) {
                        document.getElementById("divSelezioneFoto").innerHTML = codice;
                        $('#modal-seleziona-foto').modal('show');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function cambiaImmagineInEvidenzaDaPopup(percorso) {
                
                if(document.getElementById("immagineElemento")!=null) {
                    modificaImmagineElementoComponente(<?php echo $elemento["id"] ?>,percorso);
                }
                else {
                    document.getElementById("contenutoFileMultimedialeInEvidenza").innerHTML = "<img id=\"immagineElemento\" class=\"img-fluid w-100 mb-3\" src=\"../../../immagini/altro/segnaposto.png\" >";
                    modificaImmagineElementoComponente(<?php echo $elemento["id"] ?>,percorso);
                    //location.reload();
                }
                $('#modal-seleziona-foto').modal('hide');
            }
            
            function aggiungiImmaginiModalSelezioneImmagini(immaginePartenza,numeroImmagini) {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerRisorse.php",
                    data:{
                        operazione:"stampaImmaginiCartellaSlider",
                        id:<?php echo $elemento["id"] ?>,
                        immaginePartenza:immaginePartenza,
                        numeroImmagini:numeroImmagini
                    },
                    success:function(codice) {
                        var vecchioCodice = document.getElementById("divSelezioneFoto").innerHTML; 
                        document.getElementById("divSelezioneFoto").innerHTML = vecchioCodice+codice;
                        
                        // aggiorno i dati del pulsante
                        var nuovaFileMultimedialeDiPartenza = immaginePartenza+numeroImmagini;
                        document.getElementById("divBottoneModalSelezionaFoto").innerHTML = '<button type="button" class="btn btn-outline-primary" onclick="aggiungiImmaginiModalSelezioneImmagini('+nuovaFileMultimedialeDiPartenza+','+numeroImmagini+')">Mostra altre immagini</button>';
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaCampiVisibili() {
                var tipo            = document.getElementById("tipo").value;
                var divTextarea     = document.getElementById("divTextarea");
                var divLinkPulsante      = document.getElementById("divLinkPulsante");
                var divEtichettaPulsante = document.getElementById("divEtichettaPulsante");
                var divStilePulsante     = document.getElementById("divStilePulsante");
                
                divTextarea.className          = "form-group col-12";
                divLinkPulsante.className      = "form-group col-md-6";
                divEtichettaPulsante.className = "form-group col-md-3";
                divStilePulsante.className     = "form-group col-md-3";
                
                if(tipo=="html") {
                    divLinkPulsante.className      = "d-none";
                    divEtichettaPulsante.className = "d-none";
                    divStilePulsante.className     = "d-none";
                }
                else if(tipo=="soloImmagine" || tipo=="videoInTag") {
                    divTextarea.className          = "d-none";
                    divLinkPulsante.className      = "d-none";
                    divEtichettaPulsante.className = "d-none";
                    divStilePulsante.className     = "d-none";
                }
            }
        </script>

    </body>
</html>
